<?php

namespace App\Filament\Resources\Fretes\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;






class FreteForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('viagem_id')
                    ->required()
                    ->numeric(),
                TextInput::make('valor_frete')
                    ->required()
                    ->numeric(),
                TextInput::make('valor_adiantamento')
                    ->required()
                    ->numeric()
                    ->default(0.0),
                TextInput::make('valor_seguro')
                    ->required()
                    ->numeric()
                    ->default(0.0),
                TextInput::make('valor_portagem')
                    ->required()
                    ->numeric()
                    ->default(0.0),
                TextInput::make('valor_outros')
                    ->required()
                    ->numeric()
                    ->default(0.0),
                TextInput::make('valor_liquido')
                    ->required()
                    ->numeric(),
                TextInput::make('forma_pagamento')
                    ->required(),
                TextInput::make('parcelas')
                    ->required()
                    ->numeric()
                    ->default(1),
                DatePicker::make('data_vencimento')
                    ->required(),
                Select::make('status_pagamento')
                    ->options(['pendente' => 'Pendente', 'pago' => 'Pago', 'atrasado' => 'Atrasado'])
                    ->required(),
            ]);
    }
}
